/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {

        describe("Search Applet: Recent Patient List", function () {
            var view,
                viewEl,
                model = new Backbone.Model(),
                collection;

            beforeEach(function () {
                collection = new Backbone.Collection();
                view = new Portal.ListGenerator.RecentPatientListView({
                    model: model,
                    collection: collection
                });
                viewEl = view.render().$el;
            });
            afterEach(function() {
                viewEl.remove();
            });

            it("shows patient information in the list", function () {
                view.collection.add(new Portal.ListGenerator.Patient({
                    displayName: "patient01, zztest",
                    lastName: "patient01",
                    firstName: "zztest",
                    dateOfBirth: "June 16, 1900",
                    age: "110",
                    gender: "FEMALE",
                    ssn: "000-00-0000"
                }));

                var patientEl = viewEl.find('li');
                
                expect(patientEl.length).toEqual(1);
                //expect(patientEl.text()).toContain("patient01, zztest");
                //expect(patientEl.text()).toContain("06/16/1900");
                //expect(patientEl.text()).toContain("110 yo");
                //expect(patientEl.text()).toContain("F");
                //expect(patientEl.text()).toContain("000-00-0000");
            });
        });
    });